/*
 * Decompiled with CFR 0.152.
 */
package com.pixelsenpai.pixelsanticheat.client;

import com.pixelsenpai.pixelsanticheat.PixelsAntiCheat;
import com.pixelsenpai.pixelsanticheat.config.ServerConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientScanner {
    public static List<String> scanForSuspiciousMods() {
        ArrayList<String> suspiciousMods;
        block10: {
            suspiciousMods = new ArrayList<String>();
            List<String> suspiciousModIds = ServerConfig.getSuspiciousModIds();
            List<String> allowedModIds = ServerConfig.getAllowedModIds();
            block7: for (String modId : PixelsAntiCheat.modList) {
                if (ClientScanner.isModAllowed(modId, allowedModIds)) continue;
                for (String suspiciousId : suspiciousModIds) {
                    if (!modId.toLowerCase().contains(suspiciousId.toLowerCase())) continue;
                    suspiciousMods.add("Mod: " + modId);
                    continue block7;
                }
            }
            try {
                File modsDir = new File(Minecraft.getInstance().gameDirectory, "mods");
                if (!modsDir.exists() || !modsDir.isDirectory()) break block10;
                try (Stream<Path> paths = Files.walk(modsDir.toPath(), new FileVisitOption[0]);){
                    List suspiciousFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).filter(fileName -> !ClientScanner.isFileAllowed(fileName) && ClientScanner.matchesSuspiciousFilePattern(fileName)).map(file -> "File: " + file).collect(Collectors.toList());
                    suspiciousMods.addAll(suspiciousFiles);
                }
            }
            catch (IOException e) {
                PixelsAntiCheat.LOG.error("Failed to scan mods directory", (Throwable)e);
            }
        }
        return suspiciousMods;
    }

    public static List<String> scanForSuspiciousResourcePacks() {
        ArrayList<String> suspiciousPacks;
        block8: {
            suspiciousPacks = new ArrayList<String>();
            try {
                File resourcePacksDir = new File(Minecraft.getInstance().gameDirectory, "resourcepacks");
                if (!resourcePacksDir.exists() || !resourcePacksDir.isDirectory()) break block8;
                try (Stream<Path> paths = Files.walk(resourcePacksDir.toPath(), new FileVisitOption[0]);){
                    List suspiciousFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Path::toString).filter(fileName -> !ClientScanner.isResourcePackAllowed(fileName) && ClientScanner.matchesSuspiciousResourcePackPattern(fileName)).map(file -> "ResourcePack: " + file).collect(Collectors.toList());
                    suspiciousPacks.addAll(suspiciousFiles);
                }
            }
            catch (IOException e) {
                PixelsAntiCheat.LOG.error("Failed to scan resource packs directory", (Throwable)e);
            }
        }
        return suspiciousPacks;
    }

    private static boolean isModAllowed(String modId, List<String> allowedModIds) {
        for (String allowedId : allowedModIds) {
            if (!modId.equalsIgnoreCase(allowedId)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFileAllowed(String fileName) {
        List<Pattern> allowedPatterns = ServerConfig.getAllowedFilePatterns();
        for (Pattern pattern : allowedPatterns) {
            if (!pattern.matcher(fileName).matches()) continue;
            return true;
        }
        return false;
    }

    private static boolean isResourcePackAllowed(String fileName) {
        List<Pattern> allowedPatterns = ServerConfig.getAllowedResourcePackPatterns();
        for (Pattern pattern : allowedPatterns) {
            if (!pattern.matcher(fileName).matches()) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesSuspiciousFilePattern(String fileName) {
        List<Pattern> suspiciousPatterns = ServerConfig.getSuspiciousFilePatterns();
        for (Pattern pattern : suspiciousPatterns) {
            if (!pattern.matcher(fileName).matches()) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesSuspiciousResourcePackPattern(String fileName) {
        List<Pattern> suspiciousPatterns = ServerConfig.getSuspiciousResourcePackPatterns();
        for (Pattern pattern : suspiciousPatterns) {
            if (!pattern.matcher(fileName).matches()) continue;
            return true;
        }
        return false;
    }
}

