/*
 * Decompiled with CFR 0.152.
 */
package com.pixelsenpai.pixelsanticheat.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelsenpai.pixelsanticheat.PixelsAntiCheat;
import com.pixelsenpai.pixelsanticheat.config.JsonConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import net.neoforged.fml.loading.FMLPaths;

public class ServerConfig {
    private static List<String> whiteList;
    private static List<String> blackList;
    private static List<String> suspiciousModIds;
    private static List<String> allowedModIds;
    private static List<String> suspiciousFilePatterns;
    private static List<String> allowedFilePatterns;
    private static List<String> suspiciousResourcePackPatterns;
    private static List<String> allowedResourcePackPatterns;
    private static boolean kickOnSuspiciousContent;
    private static final Path CONFIG_PATH;
    private static final Gson GSON;
    private static final List<String> DEFAULT_SUSPICIOUS_MOD_IDS;
    private static final List<String> DEFAULT_ALLOWED_MOD_IDS;
    private static final List<String> DEFAULT_SUSPICIOUS_FILE_PATTERNS;
    private static final List<String> DEFAULT_ALLOWED_FILE_PATTERNS;
    private static final List<String> DEFAULT_SUSPICIOUS_RESOURCEPACK_PATTERNS;
    private static final List<String> DEFAULT_ALLOWED_RESOURCEPACK_PATTERNS;

    public static void init() {
        PixelsAntiCheat.LOG.info("Initializing PixelsAntiCheat configuration...");
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            PixelsAntiCheat.LOG.info("Configuration file not found, creating default configuration...");
            ServerConfig.createConfig();
            return;
        }
        if (!ServerConfig.validateConfig()) {
            PixelsAntiCheat.LOG.warn("Invalid configuration file detected!");
            ServerConfig.backupConfig(CONFIG_PATH);
            PixelsAntiCheat.LOG.info("Creating new default configuration...");
            ServerConfig.createConfig();
            return;
        }
        PixelsAntiCheat.LOG.info("Reading configuration from {}", (Object)CONFIG_PATH);
        ServerConfig.readConfig();
        ServerConfig.logConfigurationSummary();
    }

    private static void logConfigurationSummary() {
        PixelsAntiCheat.LOG.info("=== PixelsAntiCheat Configuration Summary ===");
        PixelsAntiCheat.LOG.info("White List: {} entries", (Object)whiteList.size());
        PixelsAntiCheat.LOG.info("Black List: {} entries", (Object)blackList.size());
        PixelsAntiCheat.LOG.info("Suspicious Mod IDs: {} entries", (Object)suspiciousModIds.size());
        PixelsAntiCheat.LOG.info("Allowed Mod IDs: {} entries", (Object)allowedModIds.size());
        PixelsAntiCheat.LOG.info("Suspicious File Patterns: {} entries", (Object)suspiciousFilePatterns.size());
        PixelsAntiCheat.LOG.info("Allowed File Patterns: {} entries", (Object)allowedFilePatterns.size());
        PixelsAntiCheat.LOG.info("Suspicious Resource Pack Patterns: {} entries", (Object)suspiciousResourcePackPatterns.size());
        PixelsAntiCheat.LOG.info("Allowed Resource Pack Patterns: {} entries", (Object)allowedResourcePackPatterns.size());
        PixelsAntiCheat.LOG.info("Kick On Suspicious Content: {}", (Object)kickOnSuspiciousContent);
        PixelsAntiCheat.LOG.info("===========================================");
    }

    public static void createConfig() {
        try {
            Files.deleteIfExists(CONFIG_PATH);
            Files.createFile(CONFIG_PATH, new FileAttribute[0]);
            JsonConfig config = new JsonConfig();
            config.addComment("WhiteList", "List of mod IDs that are always allowed");
            config.addComment("BlackList", "List of mod IDs that are always blocked");
            config.addComment("SuspiciousModIds", "List of strings that, if found in a mod ID, mark it as suspicious");
            config.addComment("AllowedModIds", "List of mod IDs that are exempt from suspicious checks");
            config.addComment("SuspiciousFilePatterns", "Regex patterns for suspicious JAR files");
            config.addComment("AllowedFilePatterns", "Regex patterns for JAR files exempt from suspicious checks");
            config.addComment("SuspiciousResourcePackPatterns", "Regex patterns for suspicious resource packs");
            config.addComment("AllowedResourcePackPatterns", "Regex patterns for resource packs exempt from suspicious checks");
            config.addComment("KickOnSuspiciousContent", "Whether to kick players with suspicious content");
            JsonArray whiteListArray = new JsonArray();
            JsonArray blackListArray = new JsonArray();
            config.addProperty("WhiteList", (JsonElement)whiteListArray);
            config.addProperty("BlackList", (JsonElement)blackListArray);
            JsonArray suspiciousModIdsArray = new JsonArray();
            for (String string : DEFAULT_SUSPICIOUS_MOD_IDS) {
                suspiciousModIdsArray.add(string);
            }
            config.addProperty("SuspiciousModIds", (JsonElement)suspiciousModIdsArray);
            JsonArray allowedModIdsArray = new JsonArray();
            for (String string : DEFAULT_ALLOWED_MOD_IDS) {
                allowedModIdsArray.add(string);
            }
            config.addProperty("AllowedModIds", (JsonElement)allowedModIdsArray);
            JsonArray jsonArray = new JsonArray();
            for (String string : DEFAULT_SUSPICIOUS_FILE_PATTERNS) {
                jsonArray.add(string);
            }
            config.addProperty("SuspiciousFilePatterns", (JsonElement)jsonArray);
            JsonArray jsonArray2 = new JsonArray();
            for (String string : DEFAULT_ALLOWED_FILE_PATTERNS) {
                jsonArray2.add(string);
            }
            config.addProperty("AllowedFilePatterns", (JsonElement)jsonArray2);
            JsonArray jsonArray3 = new JsonArray();
            for (String pattern : DEFAULT_SUSPICIOUS_RESOURCEPACK_PATTERNS) {
                jsonArray3.add(pattern);
            }
            config.addProperty("SuspiciousResourcePackPatterns", (JsonElement)jsonArray3);
            JsonArray jsonArray4 = new JsonArray();
            for (String pattern : DEFAULT_ALLOWED_RESOURCEPACK_PATTERNS) {
                jsonArray4.add(pattern);
            }
            config.addProperty("AllowedResourcePackPatterns", (JsonElement)jsonArray4);
            config.addProperty("KickOnSuspiciousContent", true);
            config.write(CONFIG_PATH);
            ServerConfig.defaultValue();
        }
        catch (IOException e) {
            PixelsAntiCheat.LOG.error("Failed to create config file: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static void readConfig() {
        if (ServerConfig.validateConfig()) {
            try {
                JsonObject object = JsonConfig.read(CONFIG_PATH);
                whiteList = ServerConfig.parseStringArray(object.get("WhiteList"));
                blackList = ServerConfig.parseStringArray(object.get("BlackList"));
                suspiciousModIds = object.has("SuspiciousModIds") ? ServerConfig.parseStringArray(object.get("SuspiciousModIds")) : new ArrayList<String>(DEFAULT_SUSPICIOUS_MOD_IDS);
                allowedModIds = object.has("AllowedModIds") ? ServerConfig.parseStringArray(object.get("AllowedModIds")) : new ArrayList<String>(DEFAULT_ALLOWED_MOD_IDS);
                suspiciousFilePatterns = object.has("SuspiciousFilePatterns") ? ServerConfig.parseStringArray(object.get("SuspiciousFilePatterns")) : new ArrayList<String>(DEFAULT_SUSPICIOUS_FILE_PATTERNS);
                allowedFilePatterns = object.has("AllowedFilePatterns") ? ServerConfig.parseStringArray(object.get("AllowedFilePatterns")) : new ArrayList<String>(DEFAULT_ALLOWED_FILE_PATTERNS);
                suspiciousResourcePackPatterns = object.has("SuspiciousResourcePackPatterns") ? ServerConfig.parseStringArray(object.get("SuspiciousResourcePackPatterns")) : new ArrayList<String>(DEFAULT_SUSPICIOUS_RESOURCEPACK_PATTERNS);
                allowedResourcePackPatterns = object.has("AllowedResourcePackPatterns") ? ServerConfig.parseStringArray(object.get("AllowedResourcePackPatterns")) : new ArrayList<String>(DEFAULT_ALLOWED_RESOURCEPACK_PATTERNS);
                kickOnSuspiciousContent = object.has("KickOnSuspiciousContent") ? object.get("KickOnSuspiciousContent").getAsBoolean() : true;
            }
            catch (Exception e) {
                PixelsAntiCheat.LOG.error("Failed to read config file: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static void backupConfig(Path configPath) {
        try {
            Path backupPath = configPath.resolveSibling(String.valueOf(configPath.getFileName()) + ".bak");
            Files.copy(configPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
            PixelsAntiCheat.LOG.info("Created backup of invalid config file at {}", (Object)backupPath);
        }
        catch (IOException e) {
            PixelsAntiCheat.LOG.error("Failed to create backup of config file", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateConfig() {
        try {
            List<String> patterns;
            if (!JsonConfig.validate(CONFIG_PATH)) {
                return false;
            }
            JsonObject object = JsonConfig.read(CONFIG_PATH);
            if (!object.has("WhiteList")) {
                return false;
            }
            if (!object.has("BlackList")) {
                return false;
            }
            if (ServerConfig.isValidArray(object.get("WhiteList"))) {
                return false;
            }
            if (ServerConfig.isValidArray(object.get("BlackList"))) {
                return false;
            }
            if (object.has("SuspiciousFilePatterns")) {
                patterns = ServerConfig.parseStringArray(object.get("SuspiciousFilePatterns"));
                for (String pattern : patterns) {
                    try {
                        Pattern.compile(pattern);
                    }
                    catch (PatternSyntaxException e) {
                        PixelsAntiCheat.LOG.error("Invalid regex pattern in SuspiciousFilePatterns: {}", (Object)pattern);
                        return false;
                    }
                }
            }
            if (object.has("AllowedFilePatterns")) {
                patterns = ServerConfig.parseStringArray(object.get("AllowedFilePatterns"));
                for (String pattern : patterns) {
                    try {
                        Pattern.compile(pattern);
                    }
                    catch (PatternSyntaxException e) {
                        PixelsAntiCheat.LOG.error("Invalid regex pattern in AllowedFilePatterns: {}", (Object)pattern);
                        return false;
                    }
                }
            }
            if (object.has("SuspiciousResourcePackPatterns")) {
                patterns = ServerConfig.parseStringArray(object.get("SuspiciousResourcePackPatterns"));
                for (String pattern : patterns) {
                    try {
                        Pattern.compile(pattern);
                    }
                    catch (PatternSyntaxException e) {
                        PixelsAntiCheat.LOG.error("Invalid regex pattern in SuspiciousResourcePackPatterns: {}", (Object)pattern);
                        return false;
                    }
                }
            }
            if (!object.has("AllowedResourcePackPatterns")) return true;
            patterns = ServerConfig.parseStringArray(object.get("AllowedResourcePackPatterns"));
            Iterator<String> iterator = patterns.iterator();
            while (iterator.hasNext()) {
                String pattern;
                pattern = iterator.next();
                try {
                    Pattern.compile(pattern);
                }
                catch (PatternSyntaxException e) {
                    PixelsAntiCheat.LOG.error("Invalid regex pattern in AllowedResourcePackPatterns: {}", (Object)pattern);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            PixelsAntiCheat.LOG.error("Error validating config: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean isValidArray(JsonElement element) {
        if (!element.isJsonArray()) {
            return true;
        }
        JsonArray array = element.getAsJsonArray();
        for (JsonElement item : array) {
            if (item.isJsonPrimitive() && item.getAsJsonPrimitive().isString()) continue;
            return true;
        }
        return false;
    }

    public static List<String> parseStringArray(JsonElement element) {
        ArrayList<String> list = new ArrayList<String>();
        if (element == null) {
            return list;
        }
        for (JsonElement item : element.getAsJsonArray()) {
            list.add(item.getAsString());
        }
        return list;
    }

    public static void defaultValue() {
        whiteList = new ArrayList<String>();
        blackList = new ArrayList<String>();
        suspiciousModIds = new ArrayList<String>(DEFAULT_SUSPICIOUS_MOD_IDS);
        allowedModIds = new ArrayList<String>(DEFAULT_ALLOWED_MOD_IDS);
        suspiciousFilePatterns = new ArrayList<String>(DEFAULT_SUSPICIOUS_FILE_PATTERNS);
        allowedFilePatterns = new ArrayList<String>(DEFAULT_ALLOWED_FILE_PATTERNS);
        suspiciousResourcePackPatterns = new ArrayList<String>(DEFAULT_SUSPICIOUS_RESOURCEPACK_PATTERNS);
        allowedResourcePackPatterns = new ArrayList<String>(DEFAULT_ALLOWED_RESOURCEPACK_PATTERNS);
        kickOnSuspiciousContent = true;
    }

    public static List<String> getWhiteList() {
        return whiteList;
    }

    public static List<String> getBlackList() {
        return blackList;
    }

    public static List<String> getSuspiciousModIds() {
        return suspiciousModIds;
    }

    public static List<String> getAllowedModIds() {
        return allowedModIds;
    }

    public static List<Pattern> getSuspiciousFilePatterns() {
        return suspiciousFilePatterns.stream().map(pattern -> {
            try {
                return Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                PixelsAntiCheat.LOG.error("Invalid regex pattern: {}", pattern);
                return null;
            }
        }).filter(pattern -> pattern != null).collect(Collectors.toList());
    }

    public static List<Pattern> getAllowedFilePatterns() {
        return allowedFilePatterns.stream().map(pattern -> {
            try {
                return Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                PixelsAntiCheat.LOG.error("Invalid regex pattern: {}", pattern);
                return null;
            }
        }).filter(pattern -> pattern != null).collect(Collectors.toList());
    }

    public static List<Pattern> getSuspiciousResourcePackPatterns() {
        return suspiciousResourcePackPatterns.stream().map(pattern -> {
            try {
                return Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                PixelsAntiCheat.LOG.error("Invalid regex pattern: {}", pattern);
                return null;
            }
        }).filter(pattern -> pattern != null).collect(Collectors.toList());
    }

    public static List<Pattern> getAllowedResourcePackPatterns() {
        return allowedResourcePackPatterns.stream().map(pattern -> {
            try {
                return Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                PixelsAntiCheat.LOG.error("Invalid regex pattern: {}", pattern);
                return null;
            }
        }).filter(pattern -> pattern != null).collect(Collectors.toList());
    }

    public static boolean getKickOnSuspiciousContent() {
        return kickOnSuspiciousContent;
    }

    static {
        CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("pixelsanticheat.json");
        GSON = new GsonBuilder().setPrettyPrinting().create();
        DEFAULT_SUSPICIOUS_MOD_IDS = Arrays.asList("wurst", "meteor", "xray", "hack", "cheat", "aristois", "impact", "inertia", "ares", "wolfram", "sigma", "liquidbounce", "baritone", "forgehax", "salhack");
        DEFAULT_ALLOWED_MOD_IDS = Arrays.asList("pixelsanticheat", "impactor", "compact", "impact-api");
        DEFAULT_SUSPICIOUS_FILE_PATTERNS = Arrays.asList("(?i).*wurst.*\\.jar", "(?i).*meteor.*\\.jar", "(?i).*xray.*\\.jar", "(?i).*hack.*\\.jar", "(?i).*cheat.*\\.jar", "(?i).*aristois.*\\.jar", "(?i).*impact.*\\.jar", "(?i).*inertia.*\\.jar", "(?i).*ares.*\\.jar", "(?i).*wolfram.*\\.jar", "(?i).*sigma.*\\.jar", "(?i).*liquidbounce.*\\.jar", "(?i).*baritone.*\\.jar", "(?i).*forgehax.*\\.jar", "(?i).*salhack.*\\.jar");
        DEFAULT_ALLOWED_FILE_PATTERNS = Arrays.asList("(?i).*pixelsanticheat.*\\.jar", "(?i).*impactor.*\\.jar", "(?i).*compact.*\\.jar");
        DEFAULT_SUSPICIOUS_RESOURCEPACK_PATTERNS = Arrays.asList("(?i).*xray.*\\.zip", "(?i).*fullbright.*\\.zip", "(?i).*cavefinder.*\\.zip", "(?i).*wireframe.*\\.zip", "(?i).*esp.*\\.zip", "(?i).*cheat.*\\.zip");
        DEFAULT_ALLOWED_RESOURCEPACK_PATTERNS = Arrays.asList("(?i).*pixelsanticheat.*\\.zip");
    }
}

