#version 120
//Reduces the resolution of the shadowmap for GI
#extension GL_EXT_gpu_shader4 : enable
varying vec2 texcoord;
const int shadowMapResolution = 4096; //[512 768 1024 1536 2048 3172 4096 8192]
uniform sampler2D shadowcolor0;
uniform sampler2D shadow;

uniform float viewWidth;
uniform float viewHeight;
uniform int frameCounter;
uniform float far;
uniform float near;
#include "lib/projections.glsl"


float linZ(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));		// (-depth * (far - near)) = (2.0 * near)/ld - far - near
}
#define SHADOW_MAP_BIAS 0.8
float calcDistort(vec2 worlpos){
	
	vec2 pos = abs(worlpos * 1.165);
	vec2 posSQ = pos*pos;
	
	float distb = pow(posSQ.x*posSQ.x*posSQ.x + posSQ.y*posSQ.y*posSQ.y, 1.0 / 6.0);
	return 1.0/((1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS);
}		



//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
/* DRAWBUFFERS:4 */

if (gl_FragCoord.x < 512 && gl_FragCoord.y < 512 ){
vec2 tc = (floor(gl_FragCoord.xy)+0.5)/512.*2-1.;
float distort = calcDistort(tc);
tc=tc*distort/0.92;
tc=tc*0.5+0.5;

gl_FragData[0]=vec4(texture2D(shadowcolor0,tc).rgb,texelFetch2D(shadow,ivec2(tc*shadowMapResolution),0).x);


}


}
