/*
 * Decompiled with CFR 0.152.
 */
package com.pixelsenpai.pixelsanticheat.util;

import com.pixelsenpai.pixelsanticheat.PixelsAntiCheat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;

public class HashUtil {
    public static String calculateModHash() {
        try {
            Optional<IModFileInfo> modFileInfo = ModList.get().getMods().stream().filter(modInfo -> modInfo.getModId().equals("pixelsanticheat")).findFirst().map(IModInfo::getOwningFile);
            if (modFileInfo.isPresent()) {
                File modFile = modFileInfo.get().getFile().getFilePath().toFile();
                return HashUtil.calculateFileHash(modFile);
            }
            PixelsAntiCheat.LOG.error("Could not find mod file for {}", (Object)"pixelsanticheat");
            return "";
        }
        catch (Exception e) {
            PixelsAntiCheat.LOG.error("Error calculating mod hash", (Throwable)e);
            return "";
        }
    }

    private static String calculateFileHash(File file) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (FileInputStream fis = new FileInputStream(file);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    digest.update(buffer, 0, bytesRead);
                }
            }
            byte[] hashBytes = digest.digest();
            return HashUtil.bytesToHex(hashBytes);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            PixelsAntiCheat.LOG.error("Error calculating file hash for {}", (Object)file.getName(), (Object)e);
            return "";
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

