#version 120
#extension GL_EXT_gpu_shader4 : enable
varying vec2 texcoord;
varying vec4 lightCol;

uniform float sunIntensity;
uniform vec3 sunPosition;
uniform float skyIntensity;
uniform float skyIntensityNight;
uniform float rainStrength;
uniform vec3 sunColor;
uniform vec3 nsunColor;
uniform mat4 gbufferModelViewInverse;

vec3 sunVec = normalize(mat3(gbufferModelViewInverse) *sunPosition);

#include "lib/sky_gradient.glsl"

vec3 coneSample(vec2 Xi)
{
	float r = sqrt(1.0f - Xi.x*Xi.y);
    float phi = 2 * 3.14159265359 * Xi.y;
 
    return normalize(vec3(cos(phi) * r, sin(phi) * r, Xi.x)).xzy;
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {

	gl_Position = ftransform();
	texcoord = gl_MultiTexCoord0.xy;

			
	lightCol.a = float(sunIntensity>0.0)*2.0-1.;
	lightCol.rgb = sunIntensity<=0.0? (1.0-sunIntensity)*vec3(0.07,0.12,0.18)/15.*(1.0-rainStrength*0.85):sunIntensity*sunColor*(1.0-rainStrength*0.8);
	
	
}